/*! \file    
**********************************************************************************	
* Title:						Discretix SST API Source file						 					
*																			
* Filename:						sst_api.c															
*																			
* Project, Target, subsystem:	SST 6.0, Stubs, API
* 
* Created:						11.03.2007														
*
* Modified:						07.06.2007										
*
* \Author						Raviv levi														
*																			
* \Remarks						
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "dx_hw_defs.h"
#include "sst_host_op_code.h"
/*----------- Local include files -------------------------------------------*/
#include "sst_data_iterators.h"





/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/

 /************************************************************************/
/*                    Indexing		                                    */
/************************************************************************/
/*SST_IndexLookupDelete*/
DxError_t SST_IndexLookupDelete (SSTTxnId_t      aTransactionId,
                                 SSTSessionId_t  aSessionId,
                                 DxUint32_t      aStringSizeInBytes,
                                 DxChar_t       *aString,
                                 DxByte_t       *aWorkspace_ptr,
                                 DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_INDEX_LOOK_UP_DELETE, 6,
	   							 /* PARAMETERS: */
								 aTransactionId,
                                 aSessionId,
                                 aStringSizeInBytes,
                                 aString,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}    

/*SST_IndexLookupBind*/
DxError_t SST_IndexLookupBind( SSTTxnId_t      aTransactionId,
                               SSTSessionId_t  aSessionId,
                               SSTHandle_t     aHandle,
                               DxUint32_t      aStringSize,
                               DxChar_t       *aString,
                               DxByte_t       *aWorkspace_ptr,
                               DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_INDEX_LOOK_UP_BIND, 8,
	   							 /* PARAMETERS: */
                               aTransactionId,
                               aSessionId,
                               aHandle,
                               aStringSize,
                               aString,
                               aWorkspace_ptr,
                               aWorkspaceSizeInBytes );
}



/*SST_IndexLookupUnbind*/
DxError_t SST_IndexLookupUnbind( SSTTxnId_t      aTransactionId,
                                 SSTSessionId_t  aSessionId,
                                 SSTHandle_t     aHandle,
                                 DxUint32_t      aStringSize,
                                 DxChar_t       *aString,
                                 DxByte_t       *aWorkspace_ptr,
                                 DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_INDEX_LOOK_UP_UNBIND, 8,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aSessionId,
                                 aHandle,
                                 aStringSize,
                                 aString,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}
DxError_t SST_IndexLookUpBegin (DxChar_t             *aString_ptr,
                                DxUint32_t            aStringLengthInBytes,
                                SSTIXCookie_t        *aIterCookie_ptr)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_INDEX_LOOK_UP_BEGIN, 3,
	   							 /* PARAMETERS: */
                                 aString_ptr,
                                 aStringLengthInBytes,
                                 aIterCookie_ptr );
}

/*SST_IndexLookUpHandlesGet*/
DxError_t SST_IndexLookUpHandlesGet(SSTSessionId_t       aSessionId,
                                    SSTIXCookie_t       *aIteratorCookie_ptr,
                                    SSTHandle_t         *aHandleBuff_ptr,
                                    DxUint32_t          *aHandlesRead_ptr,
                                    DxUint32_t          *aHandlesLeft_ptr,
                                    DxByte_t            *aWorkspace_ptr,
                                    DxUint32_t           aWorkspaceSizeInBytes)

{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_INDEX_LOOK_UP_HANDLES_GET, 7,
	   							 /* PARAMETERS: */
                                  aSessionId,
                                  aIteratorCookie_ptr,
                                  aHandleBuff_ptr,
                                  aHandlesRead_ptr,
                                  aHandlesLeft_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
  }

DxError_t  SST_IndexLookUpEnd (SSTIXCookie_t        *aIterCookie_ptr)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_INDEX_LOOK_UP_END, 1,
	   							 /* PARAMETERS: */
                                  aIterCookie_ptr );
}

/************************************************************************/
/*                    Type Iterator                                     */
/************************************************************************/
/*SST_TypeIteratorBegin*/
/*lint -save -e715*/
/* Disable PCLINT Info Msg 715: aSessionId not referenced 
-- The named formal parameter was not referenced.*/
DxError_t SST_TypeIteratorBegin(SSTSessionId_t       aSessionId,
								SSTDataType_t        aDataType,
								SSTIteratorCookie_t *aIteratorCookie_ptr,
								DxByte_t			*aWorkspace_ptr,
								DxUint32_t			aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TYPE_ITERATOR_BEGIN, 5,
	   							 /* PARAMETERS: */
                                 aSessionId,
								 aDataType,
								 aIteratorCookie_ptr,
								 aWorkspace_ptr,
								 aWorkspaceSizeInBytes );
}



/*SST_TypeIteratorTerminate*/
DxError_t SST_TypeIteratorTerminate(SSTSessionId_t      aSessionId,
									SSTIteratorCookie_t *aIteratorCookie_ptr,
									DxByte_t			*aWorkspace_ptr,
									DxUint32_t			aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TYPE_ITERATOR_TERMINATE, 4,
	   							 /* PARAMETERS: */
                                 aSessionId,
								 aIteratorCookie_ptr,
								 aWorkspace_ptr,
								 aWorkspaceSizeInBytes );
}
/*lint -restore */


/*SST_TypeIteratorHandleIncAndGet*/
DxError_t SST_TypeIteratorHandleIncAndGet(SSTSessionId_t		aSessionId,
										  SSTIteratorCookie_t	*aIteratorCookie_ptr,
										  SSTHandle_t			*aHandle_ptr,
										  DxByte_t				*aWorkspace_ptr,
										  DxUint32_t			aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLE_INC_AND_GET, 5,
	   							 /* PARAMETERS: */
                                  aSessionId,
                                  aIteratorCookie_ptr,
                                  aHandle_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes);
}




/*SST_TypeIteratorHandleDecAndGet*/
DxError_t SST_TypeIteratorHandleDecAndGet(SSTSessionId_t		aSessionId,
										  SSTIteratorCookie_t	*aIteratorCookie_ptr,
										  SSTHandle_t			*aHandle_ptr,
										  DxByte_t				*aWorkspace_ptr,
										  DxUint32_t			aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLE_DEC_AND_GET, 5,
	   							 /* PARAMETERS: */
                                  aSessionId,
                                  aIteratorCookie_ptr,
                                  aHandle_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}



/*SST_TypeIteratorCurrentGet*/
DxError_t SST_TypeIteratorCurrentGet(SSTSessionId_t      aSessionId,
									SSTIteratorCookie_t  *aIteratorCookie_ptr,
									SSTHandle_t			 *aHandle_ptr,
									DxByte_t			 *aWorkspace_ptr,
									DxUint32_t			 aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TYPE_ITERATOR_CURRENT_GET, 5,
	   							 /* PARAMETERS: */
                                  aSessionId,
                                  aIteratorCookie_ptr,
                                  aHandle_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}


/*SST_TypeIteratorHandlesGet*/
DxError_t SST_TypeIteratorHandlesGet(SSTSessionId_t       aSessionId,
                                     SSTIteratorCookie_t *aIteratorCookie_ptr,
                                     DxUint32_t          *aHandlesRead_ptr,
                                     SSTHandle_t         *aHandleBuff_ptr,
                                     DxUint32_t          *aHandlesLeft_ptr,
                                     DxByte_t            *aWorkspace_ptr,
                                     DxUint32_t           aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLES_GET, 7,
	   							 /* PARAMETERS: */
                                  aSessionId,
                                  aIteratorCookie_ptr,
                                  aHandlesRead_ptr,
                                  aHandleBuff_ptr,
                                  aHandlesLeft_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}

